# MRO Automator for Instagram

## Modificações Realizadas

Esta extensão foi personalizada com as seguintes alterações:

### 🎨 **Tema Visual - Cores MRO**
- **Cores principais**: Preto, cinza, amarelo e branco
- **Background**: Gradiente escuro (preto para cinza escuro)
- **Destaques**: Amarelo dourado (#ffcc00, #ffd700)
- **Bordas**: Mais arredondadas (border-radius: 12px-20px)
- **Sombras**: Efeitos de profundidade com box-shadow

### ✨ **Efeitos Interativos**
- **Hover nos botões**: Transformação com cores amarelas e elevação
- **Transições suaves**: Animações de 0.3s em todos os elementos
- **Efeitos de foco**: Outline amarelo para acessibilidade
- **Hover nas tabelas**: Linhas destacadas com fundo amarelo claro

### 🔧 **Alterações de Marca**
- **Nome**: "GrowBot" → "MRO" em todos os títulos
- **Arquivos**: growbot-queue.txt → mro-queue.txt
- **Arquivos**: growbot-whitelist.txt → mro-whitelist.txt
- **Exemplos**: Growbot4IG → MRO4IG

### 📁 **Arquivos Modificados**

1. **manifest.json**
   - Título da extensão alterado para "MRO Automator for Instagram"
   - Adicionados novos arquivos CSS

2. **growbot.html**
   - Título principal alterado para "MRO Automator for Instagram™"

3. **Novos arquivos CSS criados:**
   - `theme.mro.css` - Tema principal das tabelas
   - `mro-interface.css` - Interface completa da extensão

4. **contentscript.css modificado**
   - Container principal com fundo escuro
   - Cores de texto atualizadas para branco

5. **Arquivos de localização atualizados:**
   - `_locales/pt_BR/messages.json` - Traduções em português
   - `_locales/en/messages.json` - Traduções em inglês

### 🎯 **Características do Novo Tema**

#### **Paleta de Cores:**
- **Preto**: #000000, #1a1a1a (backgrounds)
- **Cinza**: #333333, #666666, #cccccc (bordas e textos)
- **Amarelo**: #ffcc00, #ffd700 (destaques e hover)
- **Branco**: #ffffff (textos principais)

#### **Efeitos Visuais:**
- Gradientes suaves em backgrounds
- Bordas arredondadas (8px-20px)
- Sombras com transparência
- Transições em hover e focus
- Scrollbars personalizadas
- Checkboxes customizados

#### **Responsividade:**
- Adaptação para telas menores
- Botões ajustáveis
- Layout flexível

### 📦 **Instalação**

1. Abra o Chrome e vá para `chrome://extensions/`
2. Ative o "Modo de desenvolvedor" no canto superior direito
3. Clique em "Carregar extensão sem compactação"
4. Selecione a pasta da extensão MRO
5. A extensão será carregada com o novo tema

### 🔄 **Compatibilidade**

- **Chrome**: Versão 88+
- **Edge**: Versão 88+
- **Opera**: Versão 74+
- **Brave**: Versões recentes

### 📋 **Notas Importantes**

- Todas as funcionalidades originais foram mantidas
- Apenas a aparência visual e o nome foram alterados
- Os scripts e lógica permanecem inalterados
- Totalmente compatível com Instagram

---

**Desenvolvido para**: MRO Team  
**Data**: Setembro 2025  
**Tema**: Preto, Cinza, Amarelo e Branco com bordas arredondadas
